/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IWireConnect;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.LinkHelper;
import com.Da_Technomancer.essentials.tileentities.redstone.RedstoneTransmitterTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;

public class RedstoneTransmitter
extends BaseEntityBlock
implements IWireConnect {
    public RedstoneTransmitter() {
        super(ESBlocks.getRockProperty());
        String name = "redstone_transmitter";
        this.setRegistryName(name);
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ESProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity te;
        worldIn.m_186464_(pos, (Block)this, 2, TickPriority.HIGH);
        if (blockIn != Blocks.f_50088_ && !(blockIn instanceof DiodeBlock) && (te = worldIn.m_7702_(pos)) instanceof RedstoneTransmitterTileEntity) {
            ((RedstoneTransmitterTileEntity)te).buildConnections();
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.m_6861_(state, worldIn, pos, (Block)this, pos, false);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        BlockEntity rawTE = worldIn.m_7702_(pos);
        if (rawTE instanceof RedstoneTransmitterTileEntity) {
            ((RedstoneTransmitterTileEntity)rawTE).refreshOutput();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = playerIn.m_21120_(hand);
        BlockEntity te = worldIn.m_7702_(pos);
        if (LinkHelper.isLinkTool(heldItem) && te instanceof RedstoneTransmitterTileEntity) {
            if (!worldIn.f_46443_) {
                LinkHelper.wrench((ILinkTE)te, heldItem, playerIn);
            }
            return InteractionResult.SUCCESS;
        }
        Item item = heldItem.m_41720_();
        if (item instanceof DyeItem && te instanceof RedstoneTransmitterTileEntity) {
            if (!worldIn.f_46443_) {
                ((RedstoneTransmitterTileEntity)te).dye(((DyeItem)item).m_41089_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)new TranslatableComponent("tt.essentials.reds_trans.desc"));
        tooltip.add((Component)new TranslatableComponent("tt.essentials.reds_trans.linking"));
        tooltip.add((Component)new TranslatableComponent("tt.essentials.reds_trans.dyes"));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RedstoneTransmitterTileEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{ESProperties.COLOR});
    }

    @Override
    public boolean canConnect(Direction side, BlockState state) {
        return true;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (state.m_60734_() != newState.m_60734_() && (te = worldIn.m_7702_(pos)) instanceof RedstoneTransmitterTileEntity) {
            ((RedstoneTransmitterTileEntity)te).linkHelper.unlinkAllEndpoints();
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

